<?php
require_once 'config.php';

// Handle delete operation
if (isset($_GET['delete'])) {
    $delete_id = intval($_GET['delete']);
    $delete_query = "DELETE FROM gallery WHERE id = $delete_id";
    $conn->query($delete_query);
    header("Location: gallery-admin.php?message=Image deleted successfully");
    exit;
}

// Handle add/update operation
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $title = $conn->real_escape_string($_POST['title']);
    $description = $conn->real_escape_string($_POST['description']);
    $image_url = $conn->real_escape_string($_POST['image_url']);
    $category = $conn->real_escape_string($_POST['category']);
    $status = isset($_POST['status']) ? 'active' : 'inactive';
    
    if (isset($_POST['edit_id']) && !empty($_POST['edit_id'])) {
        // Update existing
        $edit_id = intval($_POST['edit_id']);
        $update_query = "UPDATE gallery SET title='$title', description='$description', image_url='$image_url', category='$category', status='$status' WHERE id=$edit_id";
        $conn->query($update_query);
        $message = "Image updated successfully";
    } else {
        // Insert new
        $insert_query = "INSERT INTO gallery (title, description, image_url, category, status) VALUES ('$title', '$description', '$image_url', '$category', '$status')";
        $conn->query($insert_query);
        $message = "Image added successfully";
    }
    
    header("Location: gallery-admin.php?message=$message");
    exit;
}

// Fetch all gallery images
$query = "SELECT * FROM gallery ORDER BY created_at DESC";
$result = $conn->query($query);
$images = $result->fetch_all(MYSQLI_ASSOC);

// Get edit data if provided
$edit_data = null;
if (isset($_GET['edit'])) {
    $edit_id = intval($_GET['edit']);
    $edit_query = "SELECT * FROM gallery WHERE id=$edit_id";
    $edit_result = $conn->query($edit_query);
    $edit_data = $edit_result->fetch_assoc();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gallery Admin - Cleaning Service</title>
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        body {
            background: #f8fbff;
            font-family: 'Poppins', sans-serif;
            padding: 20px;
        }
        .admin-container {
            max-width: 1200px;
            margin: 0 auto;
        }
        .header {
            background: linear-gradient(135deg, #109c3d, #0f8c3d);
            color: white;
            padding: 30px;
            border-radius: 15px;
            margin-bottom: 30px;
        }
        .header h1 {
            margin: 0;
            font-size: 32px;
            font-weight: 700;
        }
        .form-card {
            background: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            margin-bottom: 30px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-label {
            font-weight: 600;
            color: #0f172a;
            margin-bottom: 8px;
        }
        .form-control {
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            padding: 12px;
            transition: all 0.3s ease;
        }
        .form-control:focus {
            border-color: #109c3d;
            box-shadow: 0 0 0 3px rgba(16, 156, 61, 0.1);
        }
        .btn-submit {
            background: linear-gradient(135deg, #109c3d, #0f8c3d);
            color: white;
            border: none;
            padding: 12px 30px;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(16, 156, 61, 0.3);
        }
        .btn-cancel {
            background: #f1f5f4;
            color: #109c3d;
            border: 2px solid #109c3d;
            padding: 12px 30px;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            transition: all 0.3s ease;
        }
        .btn-cancel:hover {
            background: #e8eeec;
        }
        .message {
            background: #e8f5e9;
            color: #2e7d32;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            border-left: 4px solid #4caf50;
        }
        .gallery-table {
            background: white;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }
        .gallery-table table {
            margin: 0;
        }
        .gallery-table th {
            background: #f1f5f4;
            color: #0f172a;
            font-weight: 600;
            border: none;
            padding: 15px;
        }
        .gallery-table td {
            padding: 15px;
            border-color: #e0e0e0;
            vertical-align: middle;
        }
        .gallery-table img {
            max-width: 80px;
            height: 80px;
            object-fit: cover;
            border-radius: 8px;
        }
        .status-active {
            background: #e8f5e9;
            color: #2e7d32;
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }
        .status-inactive {
            background: #ffebee;
            color: #c62828;
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }
        .action-buttons {
            display: flex;
            gap: 8px;
        }
        .btn-edit, .btn-delete {
            padding: 8px 15px;
            border-radius: 6px;
            font-size: 12px;
            font-weight: 600;
            text-decoration: none;
            transition: all 0.3s ease;
        }
        .btn-edit {
            background: #4fc3f7;
            color: white;
        }
        .btn-edit:hover {
            background: #29b6f6;
            transform: translateY(-2px);
        }
        .btn-delete {
            background: #ef5350;
            color: white;
        }
        .btn-delete:hover {
            background: #e53935;
            transform: translateY(-2px);
        }
        .checkbox-group {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .checkbox-group input {
            width: auto;
        }
        .form-group-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
        }
        @media (max-width: 768px) {
            .form-group-row {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="admin-container">
        <!-- Header -->
        <div class="header">
            <h1>🖼️ Gallery Management</h1>
            <p>Add, Edit, or Delete portfolio images</p>
        </div>

        <!-- Message -->
        <?php if (isset($_GET['message'])): ?>
        <div class="message">
            ✓ <?php echo htmlspecialchars($_GET['message']); ?>
        </div>
        <?php endif; ?>

        <!-- Form -->
        <div class="form-card">
            <h3 style="margin-bottom: 20px; color: #0f172a;">
                <?php echo $edit_data ? 'Edit Image' : 'Add New Image'; ?>
            </h3>

            <form method="POST">
                <?php if ($edit_data): ?>
                <input type="hidden" name="edit_id" value="<?php echo $edit_data['id']; ?>">
                <?php endif; ?>

                <div class="form-group-row">
                    <div>
                        <label class="form-label">Image Title *</label>
                        <input type="text" name="title" class="form-control" required value="<?php echo $edit_data ? htmlspecialchars($edit_data['title']) : ''; ?>" placeholder="e.g., Bed & Mattress Care">
                    </div>
                    <div>
                        <label class="form-label">Category *</label>
                        <input type="text" name="category" class="form-control" required value="<?php echo $edit_data ? htmlspecialchars($edit_data['category']) : ''; ?>" placeholder="e.g., residential, commercial">
                    </div>
                </div>

                <div class="form-group">
                    <label class="form-label">Description *</label>
                    <input type="text" name="description" class="form-control" required value="<?php echo $edit_data ? htmlspecialchars($edit_data['description']) : ''; ?>" placeholder="e.g., Deep Cleaning">
                </div>

                <div class="form-group">
                    <label class="form-label">Image URL *</label>
                    <input type="text" name="image_url" class="form-control" required value="<?php echo $edit_data ? htmlspecialchars($edit_data['image_url']) : ''; ?>" placeholder="e.g., assets/img/gallery/image.jpg">
                </div>

                <div class="form-group">
                    <div class="checkbox-group">
                        <input type="checkbox" name="status" id="status" value="1" <?php echo ($edit_data && $edit_data['status'] == 'active') ? 'checked' : 'checked'; ?>>
                        <label for="status" style="margin: 0;">Active</label>
                    </div>
                </div>

                <div>
                    <button type="submit" class="btn-submit">
                        <?php echo $edit_data ? '✓ Update Image' : '+ Add Image'; ?>
                    </button>
                    <?php if ($edit_data): ?>
                    <a href="gallery-admin.php" class="btn-cancel">Cancel</a>
                    <?php endif; ?>
                </div>
            </form>
        </div>

        <!-- Gallery Table -->
        <div class="gallery-table">
            <h3 style="padding: 20px 30px; margin: 0; border-bottom: 2px solid #f1f5f4;">All Images (<?php echo count($images); ?>)</h3>
            
            <?php if (count($images) > 0): ?>
            <table class="table table-hover" style="margin: 0;">
                <thead>
                    <tr>
                        <th>Image</th>
                        <th>Title</th>
                        <th>Category</th>
                        <th>Description</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($images as $image): ?>
                    <tr>
                        <td><img src="<?php echo htmlspecialchars($image['image_url']); ?>" alt="<?php echo htmlspecialchars($image['title']); ?>"></td>
                        <td><strong><?php echo htmlspecialchars($image['title']); ?></strong></td>
                        <td><?php echo htmlspecialchars($image['category']); ?></td>
                        <td><?php echo htmlspecialchars($image['description']); ?></td>
                        <td>
                            <span class="<?php echo $image['status'] == 'active' ? 'status-active' : 'status-inactive'; ?>">
                                <?php echo ucfirst($image['status']); ?>
                            </span>
                        </td>
                        <td>
                            <div class="action-buttons">
                                <a href="?edit=<?php echo $image['id']; ?>" class="btn-edit">Edit</a>
                                <a href="?delete=<?php echo $image['id']; ?>" class="btn-delete" onclick="return confirm('Are you sure?')">Delete</a>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <?php else: ?>
            <div style="padding: 30px; text-align: center; color: #999;">
                <p>No images found. Add your first image using the form above.</p>
            </div>
            <?php endif; ?>
        </div>

        <!-- Back Link -->
        <div style="margin-top: 30px; text-align: center;">
            <a href="portfolio.php" style="color: #109c3d; text-decoration: none; font-weight: 600;">← Back to Gallery</a>
        </div>
    </div>

    <script src="assets/js/bootstrap.min.js"></script>
</body>
</html>
